<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\AuditLog;
use Illuminate\Http\Request;

class AuditLogController extends Controller
{
    /**
     * GET /api/audit-logs?entity_type=&entity_id=&event=&user_id=&from=&to=&per_page=
     */
    public function index(Request $request)
    {
        $q = AuditLog::with(['user:id,name,email'])
            ->orderByDesc('created_at');

        if ($entityType = $request->query('entity_type')) {
            $q->where('entity_type', $entityType);
        }
        if ($entityId = $request->query('entity_id')) {
            $q->where('entity_id', (int)$entityId);
        }
        if ($event = $request->query('event')) {
            $q->where('event', $event);
        }
        if ($userId = $request->query('user_id')) {
            $q->where('user_id', (int)$userId);
        }

        // Date range filters (optional)
        if ($from = $request->query('from')) {
            $q->whereDate('created_at', '>=', $from); // YYYY-MM-DD
        }
        if ($to = $request->query('to')) {
            $q->whereDate('created_at', '<=', $to); // YYYY-MM-DD
        }

        return response()->json([
            'message' => 'Audit logs retrieved successfully.',
            'data' => $q->paginate($request->query('per_page', 20)),
        ]);
    }

    /**
     * GET /api/audit-logs/{auditLog}
     */
    public function show(AuditLog $auditLog)
    {
        $auditLog->load(['user:id,name,email']);

        return response()->json([
            'message' => 'Audit log retrieved successfully.',
            'data' => $auditLog,
        ]);
    }
}
