<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class ApprovalAction extends Model
{
    protected $fillable = [
        'submission_id',
        'acted_by',
        'action',
        'comment',
        'from_status',
        'to_status',
        'ip_address',
        'user_agent',
    ];

    protected $casts = [
        // if you later create an Enum class, change to that enum cast
        'action' => 'string',
    ];

    public function submission(): BelongsTo
    {
        return $this->belongsTo(Submission::class, 'submission_id');
    }

    public function actor(): BelongsTo
    {
        return $this->belongsTo(User::class, 'acted_by');
    }

    /** Quick filter scope: ApprovalAction::forSubmission($id)->latest()->get() */
    public function scopeForSubmission(Builder $query, int $submissionId): Builder
    {
        return $query->where('submission_id', $submissionId);
    }
}
