<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class GiiPillar extends Model
{
    protected $fillable = [
        'gii_version_id',
        'pillar_number',
        'code',
        'name',
        'description',
        'is_active',
        'display_order',
    ];

    protected $casts = [
        'pillar_number' => 'integer',
        'display_order' => 'integer',
        'is_active'     => 'boolean',
    ];

    public function version(): BelongsTo
    {
        return $this->belongsTo(GiiVersion::class, 'gii_version_id');
    }

    public function subpillars(): HasMany
    {
        return $this->hasMany(GiiSubpillar::class, 'gii_pillar_id');
    }

    public function scopeActive(Builder $query): Builder
    {
        return $query->where('is_active', true);
    }
}
