<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class GiiSubpillar extends Model
{
    protected $fillable = [
        'gii_pillar_id',
        'code',
        'name',
        'description',
        'is_active',
        'display_order',
    ];

    protected $casts = [
        'is_active'     => 'boolean',
        'display_order' => 'integer',
    ];

    public function pillar(): BelongsTo
    {
        return $this->belongsTo(GiiPillar::class, 'gii_pillar_id');
    }

    public function indicators(): HasMany
    {
        return $this->hasMany(GiiIndicator::class, 'gii_subpillar_id');
    }

    public function scopeActive(Builder $query): Builder
    {
        return $query->where('is_active', true);
    }
}
