<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class GiiVersion extends Model
{
    protected $fillable = [
        'year',
        'name',
        'is_active',
    ];

    protected $casts = [
        'is_active' => 'boolean',
    ];

    /* --------------------
     | Relationships
     |--------------------*/

    public function pillars(): HasMany
    {
        return $this->hasMany(GiiPillar::class);
    }

    public function exports(): HasMany
    {
        return $this->hasMany(Export::class);
    }

    public function nationalScores(): HasMany
    {
        return $this->hasMany(NationalScore::class);
    }

    /* --------------------
     | Query scopes
     |--------------------*/

    public function scopeActive(Builder $query): Builder
    {
        return $query->where('is_active', true);
    }
}
