<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class IndicatorFormula extends Model
{
    protected $fillable = [
        'gii_indicator_id',
        'formula_type',
        'formula',
        'params',
        'version',
        'is_active',
        'checksum',
    ];

    protected $casts = [
        'params'    => 'array',
        'version'   => 'integer',
        'is_active' => 'boolean',
    ];

    public function indicator(): BelongsTo
    {
        return $this->belongsTo(GiiIndicator::class, 'gii_indicator_id');
    }

    public function scopeActive(Builder $query): Builder
    {
        return $query->where('is_active', true);
    }
}
