<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class RawRecord extends Model
{
    protected $fillable = [
        'submission_id',
        'payload',
        'hash',
        'source_reference',
        'status',
        'notes',
    ];

    protected $casts = ['payload' => 'array'];

    public function submission(): BelongsTo
    {
        return $this->belongsTo(Submission::class);
    }
}
