<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Submission extends Model
{
    protected $fillable = [
        'institution_id',
        'submitted_by',
        'gii_indicator_id',
        'year',
        'month',
        'source',
        'status',
        'notes',
        'rejection_reason',
    ];

    protected $casts = [
        'year'  => 'integer',
        'month' => 'integer',
    ];

    public function institution(): BelongsTo
    {
        return $this->belongsTo(Institution::class, 'institution_id');
    }

    public function submitter(): BelongsTo
    {
        return $this->belongsTo(User::class, 'submitted_by');
    }

    public function indicator(): BelongsTo
    {
        return $this->belongsTo(GiiIndicator::class, 'gii_indicator_id');
    }

    public function files(): HasMany
    {
        return $this->hasMany(SubmissionFile::class, 'submission_id');
    }

    public function rawRecords(): HasMany
    {
        return $this->hasMany(RawRecord::class, 'submission_id');
    }

    public function validations(): HasMany
    {
        return $this->hasMany(ValidationResult::class, 'submission_id');
    }

    public function approvals(): HasMany
    {
        return $this->hasMany(ApprovalAction::class, 'submission_id');
    }

    public function scopeStatus(Builder $query, string $status): Builder
    {
        return $query->where('status', $status);
    }
}
