<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('gii_versions', function (Blueprint $table) {
            $table->id();

            $table->string('year')
                ->unique()
                ->comment('GII reporting year e.g. 2025');

            $table->string('name')
                ->nullable()
                ->comment('Human-readable name e.g. GII 2025');

            $table->boolean('is_active')
                ->default(false)
                ->comment('Only one version should be active at a time');

            $table->timestamps();

            $table->index('is_active');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('gii_versions');
    }
};
