<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('gii_pillars', function (Blueprint $table) {
            $table->id();

            $table->foreignId('gii_version_id')
                ->constrained('gii_versions')
                ->cascadeOnDelete();

            $table->unsignedTinyInteger('pillar_number')
                ->comment('GII pillar number (1–7)');

            $table->string('code', 10)
                ->nullable()
                ->comment('Optional code e.g. P1, P2');

            $table->string('name')
                ->comment('Pillar name e.g. Institutions');

            $table->text('description')->nullable();

            $table->boolean('is_active')
                ->default(true)
                ->comment('Deactivate without deleting history');

            $table->unsignedSmallInteger('display_order')
                ->default(0)
                ->comment('Ordering in UI/exports');

            $table->timestamps();

            $table->unique(['gii_version_id', 'pillar_number'], 'uniq_gii_version_pillar');
            $table->unique(['gii_version_id', 'name'], 'uniq_gii_version_pillar_name');
            $table->index(['gii_version_id', 'display_order'], 'idx_pillar_version_order');
            $table->index('is_active', 'idx_pillar_active');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('gii_pillars');
    }
};
