<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('gii_subpillars', function (Blueprint $table) {
            $table->id();

            $table->foreignId('gii_pillar_id')
                ->constrained('gii_pillars')
                ->cascadeOnDelete();

            $table->string('code', 20)
                ->nullable()
                ->comment('Optional code e.g. 1.1, 2.3');

            $table->string('name')
                ->comment('Sub-pillar name');

            $table->text('description')->nullable();

            $table->boolean('is_active')
                ->default(true)
                ->comment('Deactivate without deleting historical data');

            $table->unsignedSmallInteger('display_order')
                ->default(0)
                ->comment('Ordering under pillar for UI/export consistency');

            $table->timestamps();

            // Prevent duplicates under same pillar
            $table->unique(['gii_pillar_id', 'code'], 'uniq_subpillar_code_per_pillar');
            $table->unique(['gii_pillar_id', 'name'], 'uniq_subpillar_name_per_pillar');

            // Helpful index
            $table->index(['gii_pillar_id', 'display_order'], 'idx_subpillar_pillar_order');
            $table->index('is_active', 'idx_subpillar_active');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('gii_subpillars');
    }
};
