<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('gii_indicators', function (Blueprint $table) {
            $table->id();

            $table->foreignId('gii_subpillar_id')
                ->constrained('gii_subpillars')
                ->cascadeOnDelete();

            $table->string('code', 50)
                ->comment('Indicator code e.g. 1.1.1');

            $table->string('name')
                ->comment('Indicator name');

            $table->string('unit', 50)
                ->nullable()
                ->comment('Unit e.g. %, count, index, USD');

            $table->enum('periodicity', ['yearly', 'quarterly', 'monthly'])
                ->default('yearly')
                ->comment('How often indicator is collected');

            $table->boolean('is_computed')
                ->default(false)
                ->comment('Computed indicator vs directly supplied');

            $table->boolean('is_active')
                ->default(true)
                ->comment('Deactivate without deleting history');

            $table->unsignedSmallInteger('display_order')
                ->default(0)
                ->comment('Ordering within subpillar');

            $table->json('meta')
                ->nullable()
                ->comment('Extra metadata: definition, methodology, source hints');

            $table->timestamps();

            $table->unique(['gii_subpillar_id', 'code'], 'uniq_indicator_code_per_subpillar');
            $table->unique(['gii_subpillar_id', 'name'], 'uniq_indicator_name_per_subpillar');

            $table->index(['gii_subpillar_id', 'display_order'], 'idx_indicator_subpillar_order');
            $table->index('code', 'idx_indicator_code');
            $table->index('is_active', 'idx_indicator_active');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('gii_indicators');
    }
};
