<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('indicator_formulas', function (Blueprint $table) {
            $table->id();

            $table->foreignId('gii_indicator_id')
                ->constrained('gii_indicators')
                ->cascadeOnDelete();

            $table->enum('formula_type', ['none', 'expression', 'sql', 'php', 'python'])
                ->default('none')
                ->comment('How the indicator is computed');

            $table->longText('formula')
                ->nullable()
                ->comment('Expression/code reference or stored formula text');

            $table->json('params')
                ->nullable()
                ->comment('JSON parameters (weights, dependencies, config)');

            $table->unsignedSmallInteger('version')
                ->default(1)
                ->comment('Formula version for audit/change tracking');

            $table->boolean('is_active')
                ->default(true)
                ->comment('Only one active formula per indicator is recommended');

            $table->string('checksum', 64)
                ->nullable()
                ->comment('Optional SHA256 for integrity verification');

            $table->timestamps();

            $table->index(['gii_indicator_id', 'is_active'], 'idx_formula_indicator_active');
            $table->index('formula_type', 'idx_formula_type');
            $table->index('version', 'idx_formula_version');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('indicator_formulas');
    }
};
