<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('submissions', function (Blueprint $table) {
            $table->id();

            $table->foreignId('institution_id')
                ->constrained('institutions')
                ->cascadeOnDelete();

            $table->foreignId('submitted_by')
                ->nullable()
                ->constrained('users')
                ->nullOnDelete();

            // Optional: if each submission is tied to a specific indicator.
            // If you want multi-indicator submissions later, remove this and use observations mapping from raw_records.
            $table->foreignId('gii_indicator_id')
                ->nullable()
                ->constrained('gii_indicators')
                ->nullOnDelete();

            $table->unsignedSmallInteger('year');
            $table->unsignedTinyInteger('month')->nullable();

            $table->string('source', 100)
                ->default('portal')
                ->comment('portal, api, batch_upload');

            $table->enum('status', ['DRAFT','SUBMITTED','VALIDATED','APPROVED','PUBLISHED','REJECTED'])
                ->default('DRAFT');

            $table->text('notes')->nullable();
            $table->text('rejection_reason')->nullable();

            $table->timestamps();

            $table->index(['institution_id', 'year'], 'idx_submission_institution_year');
            $table->index(['gii_indicator_id', 'year'], 'idx_submission_indicator_year');
            $table->index('status', 'idx_submission_status');
            $table->index('source', 'idx_submission_source');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('submissions');
    }
};
