<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('submission_files', function (Blueprint $table) {
            $table->id();

            // Link to submission
            $table->foreignId('submission_id')
                ->constrained('submissions')
                ->cascadeOnDelete();

            // Storage details
            $table->string('path')
                ->comment('Storage path of the uploaded file');

            $table->string('original_name')
                ->nullable()
                ->comment('Original uploaded file name');

            $table->string('mime', 100)
                ->nullable()
                ->comment('MIME type e.g. application/pdf');

            $table->unsignedBigInteger('size')
                ->nullable()
                ->comment('File size in bytes');

            // Evidence classification
            $table->string('file_type', 50)
                ->default('evidence')
                ->comment('evidence, dataset, report, annex');

            // Integrity & audit
            $table->string('checksum', 64)
                ->nullable()
                ->comment('SHA256 checksum for integrity verification');

            // Who uploaded the file
            $table->foreignId('uploaded_by')
                ->nullable()
                ->constrained('users')
                ->nullOnDelete();

            $table->timestamps();

            // Useful indexes
            $table->index('submission_id', 'idx_submission_file_submission');
            $table->index('file_type', 'idx_submission_file_type');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('submission_files');
    }
};
