<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('approval_actions', function (Blueprint $table) {
            $table->id();

            $table->foreignId('submission_id')
                ->constrained('submissions')
                ->cascadeOnDelete();

            $table->foreignId('acted_by')
                ->nullable()
                ->constrained('users')
                ->nullOnDelete();

            $table->enum('action', ['SUBMIT','VALIDATE','APPROVE','PUBLISH','REJECT']);

            $table->text('comment')->nullable();

            $table->string('from_status', 20)->nullable();
            $table->string('to_status', 20)->nullable();

            $table->ipAddress('ip_address')->nullable();
            $table->string('user_agent')->nullable();

            $table->timestamps();

            $table->index('submission_id', 'idx_approval_submission');
            $table->index('action', 'idx_approval_action');
            $table->index('acted_by', 'idx_approval_actor');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('approval_actions');
    }
};
