<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('pillar_scores', function (Blueprint $table) {
            $table->id();

            // Which pillar this score belongs to
            $table->foreignId('gii_pillar_id')
                ->constrained('gii_pillars')
                ->cascadeOnDelete();

            // Reporting year (GII is annual)
            $table->unsignedSmallInteger('year')
                ->comment('Reporting year');

            // Computed pillar score
            $table->decimal('score', 10, 4)
                ->nullable()
                ->comment('Computed pillar score');

            // Scoring methodology and breakdown
            $table->json('meta')
                ->nullable()
                ->comment('Aggregation method, weights, indicator list, normalization details');

            // Workflow state (optional but useful)
            $table->enum('status', ['DRAFT', 'APPROVED', 'PUBLISHED'])
                ->default('DRAFT')
                ->comment('Score lifecycle status');

            $table->timestamps();

            // One score per pillar per year
            $table->unique(
                ['gii_pillar_id', 'year'],
                'uniq_pillar_score_year'
            );

            // Indexes for dashboards and reports
            $table->index('year', 'idx_pillar_score_year');
            $table->index('status', 'idx_pillar_score_status');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('pillar_scores');
    }
};
