<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('exports', function (Blueprint $table) {
            $table->id();

            // Who requested the export (user or system)
            $table->foreignId('requested_by')
                ->nullable()
                ->constrained('users')
                ->nullOnDelete();

            // GII framework version
            $table->foreignId('gii_version_id')
                ->constrained('gii_versions')
                ->cascadeOnDelete();

            // Reporting year
            $table->unsignedSmallInteger('year');

            // Export type
            $table->enum('type', ['wipo', 'internal', 'dashboard', 'api'])
                ->default('wipo');

            // Processing lifecycle
            $table->enum('status', ['PENDING', 'GENERATED', 'FAILED'])
                ->default('PENDING');

            // File path
            $table->string('path')->nullable();

            // Error message if failed
            $table->text('error')->nullable();

            // Export parameters & filters
            $table->json('meta')->nullable();

            $table->timestamps();

            // Prevent duplicate exports
            $table->unique(
                ['gii_version_id', 'year', 'type'],
                'uniq_export_version_year_type'
            );

            // Indexes
            $table->index('status');
            $table->index('type');
            $table->index('year');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('exports');
    }
};
