<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\KnowledgeAiController;

/*
|--------------------------------------------------------------------------
| API ROUTES (No CSRF, JSON responses)
|--------------------------------------------------------------------------
*/

Route::get('/ping', function () {
    return response()->json(['message' => 'API is working']);
});

/* =============================
   KNOWLEDGE CRUD API
============================= */

Route::get('/knowledges', [KnowledgeAiController::class, 'index']);
Route::post('/knowledge', [KnowledgeAiController::class, 'store']);
Route::get('/knowledge/{id}', [KnowledgeAiController::class, 'show']);
Route::put('/knowledge/{id}', [KnowledgeAiController::class, 'update']);
Route::delete('/knowledge/{id}', [KnowledgeAiController::class, 'destroy']);

/* =============================
   AI ROUTES
============================= */

Route::get('/knowledge/search', [KnowledgeAiController::class, 'search']);
Route::post('/ask-ai', [KnowledgeAiController::class, 'askAI']);
