<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Admin\ApprovalActionController;
use App\Http\Controllers\Admin\AuditLogController;
use App\Http\Controllers\Admin\ExportController;
use App\Http\Controllers\Admin\InstitutionController;
use App\Http\Controllers\Admin\GiiVersionController;
use App\Http\Controllers\Admin\GiiPillarController;
use App\Http\Controllers\Admin\GiiIndicatorController;
use App\Http\Controllers\Admin\GiiSubpillarController;
use App\Http\Controllers\Admin\IndicatorFormulaController;
use App\Http\Controllers\IndicatorObservationController;
use App\Http\Controllers\NationalScoreController;
use App\Http\Controllers\PillarScoreController;
use App\Http\Controllers\RawRecordController;
use App\Http\Controllers\SubmissionController;
use App\Http\Controllers\SubmissionFileController;

Route::get('/indicator-formulas', [IndicatorFormulaController::class, 'index']);
Route::get('/indicator-formulas/{indicatorFormula}', [IndicatorFormulaController::class, 'show']);
Route::post('/indicator-formulas', [IndicatorFormulaController::class, 'store']);
Route::put('/indicator-formulas/{indicatorFormula}', [IndicatorFormulaController::class, 'update']);
Route::patch('/indicator-formulas/{indicatorFormula}/activate', [IndicatorFormulaController::class, 'activate']);


Route::get('/gii-indicators', [GiiIndicatorController::class, 'index']);
Route::get('/gii-indicators/{giiIndicator}', [GiiIndicatorController::class, 'show']);
Route::post('/gii-indicators', [GiiIndicatorController::class, 'store']);
Route::put('/gii-indicators/{giiIndicator}', [GiiIndicatorController::class, 'update']);
Route::patch('/gii-indicators/{giiIndicator}/toggle', [GiiIndicatorController::class, 'toggle']);


Route::get('/gii-pillars', [GiiPillarController::class, 'index']);
Route::get('/gii-pillars/{giiPillar}', [GiiPillarController::class, 'show']);
Route::post('/gii-pillars', [GiiPillarController::class, 'store']);
Route::put('/gii-pillars/{giiPillar}', [GiiPillarController::class, 'update']);
Route::patch('/gii-pillars/{giiPillar}/toggle', [GiiPillarController::class, 'toggle']);

Route::get('/gii-subpillars', [GiiSubpillarController::class, 'index']);
Route::get('/gii-subpillars/{giiSubpillar}', [GiiSubpillarController::class, 'show']);
Route::post('/gii-subpillars', [GiiSubpillarController::class, 'store']);
Route::put('/gii-subpillars/{giiSubpillar}', [GiiSubpillarController::class, 'update']);
Route::patch('/gii-subpillars/{giiSubpillar}/toggle', [GiiSubpillarController::class, 'toggle']);


Route::get('/gii-versions', [GiiVersionController::class, 'index']);
Route::get('/gii-versions/{giiVersion}', [GiiVersionController::class, 'show']);
Route::post('/gii-versions', [GiiVersionController::class, 'store']);
Route::put('/gii-versions/{giiVersion}', [GiiVersionController::class, 'update']);
Route::patch('/gii-versions/{giiVersion}/activate', [GiiVersionController::class, 'activate']);



Route::get('/institutions', [InstitutionController::class, 'index']);
Route::get('/institutions/{institution}', [InstitutionController::class, 'show']);
Route::post('/institutions', [InstitutionController::class, 'store']);
Route::put('/institutions/{institution}', [InstitutionController::class, 'update']);
Route::patch('/institutions/{institution}/toggle', [InstitutionController::class, 'toggle']);
Route::get('/submissions', [SubmissionController::class, 'index']);
Route::post('/submissions', [SubmissionController::class, 'store']);
Route::get('/submissions/{submission}', [SubmissionController::class, 'show']);
Route::post('/submissions/{submission}/files', [SubmissionController::class, 'upload']);
Route::post('/submissions/{submission}/raw-records', [SubmissionController::class, 'addRawRecord']);

Route::get('/submission-files', [SubmissionFileController::class, 'index']);
Route::post('/submission-files', [SubmissionFileController::class, 'store']);
Route::get('/submission-files/{submissionFile}', [SubmissionFileController::class, 'show']);
Route::put('/submission-files/{submissionFile}', [SubmissionFileController::class, 'update']);
Route::delete('/submission-files/{submissionFile}', [SubmissionFileController::class, 'destroy']);

Route::get('/raw-records', [RawRecordController::class, 'index']);
Route::post('/raw-records', [RawRecordController::class, 'store']);
Route::get('/raw-records/{rawRecord}', [RawRecordController::class, 'show']);
Route::put('/raw-records/{rawRecord}', [RawRecordController::class, 'update']);
Route::delete('/raw-records/{rawRecord}', [RawRecordController::class, 'destroy']);

Route::get('/indicator-observations', [IndicatorObservationController::class, 'index']);
Route::post('/indicator-observations', [IndicatorObservationController::class, 'store']);
Route::get('/indicator-observations/{indicatorObservation}', [IndicatorObservationController::class, 'show']);
Route::put('/indicator-observations/{indicatorObservation}', [IndicatorObservationController::class, 'update']);
Route::delete('/indicator-observations/{indicatorObservation}', [IndicatorObservationController::class, 'destroy']);

Route::post('/analytics/{year}/compute', [IndicatorObservationController::class, 'compute']);
Route::get('/analytics/{year}/pillar-scores', [IndicatorObservationController::class, 'pillarScores']);
Route::get('/analytics/{year}/national-score', [IndicatorObservationController::class, 'nationalScore']);

Route::get('/pillar-scores', [PillarScoreController::class, 'index']);
Route::post('/pillar-scores', [PillarScoreController::class, 'store']);
Route::get('/pillar-scores/{pillarScore}', [PillarScoreController::class, 'show']);
Route::put('/pillar-scores/{pillarScore}', [PillarScoreController::class, 'update']);
Route::delete('/pillar-scores/{pillarScore}', [PillarScoreController::class, 'destroy']);

Route::get('/national-scores', [NationalScoreController::class, 'index']);
Route::post('/national-scores', [NationalScoreController::class, 'store']);
Route::get('/national-scores/{nationalScore}', [NationalScoreController::class, 'show']);
Route::put('/national-scores/{nationalScore}', [NationalScoreController::class, 'update']);
Route::delete('/national-scores/{nationalScore}', [NationalScoreController::class, 'destroy']);



Route::get('/exports', [ExportController::class, 'index']);
Route::get('/exports/{export}', [ExportController::class, 'show']);
Route::post('/exports', [ExportController::class, 'store']);
Route::post('/exports/{export}/generate', [ExportController::class, 'generate']);
Route::get('/exports/{export}/download', [ExportController::class, 'download']);



Route::get('/audit-logs', [AuditLogController::class, 'index']);
Route::get('/audit-logs/{auditLog}', [AuditLogController::class, 'show']);


    // Approval actions (audit trail)
Route::get('/approval-actions', [ApprovalActionController::class, 'index']);
Route::get('/approval-actions/{approvalAction}', [ApprovalActionController::class, 'show']);

// Submission workflow (kept inside same controller as requested)
Route::post('/submissions/{submission}/submit', [ApprovalActionController::class, 'submit']);
Route::post('/submissions/{submission}/validate', [ApprovalActionController::class, 'validateSubmission']);
Route::post('/submissions/{submission}/approve', [ApprovalActionController::class, 'approve']);
Route::post('/submissions/{submission}/publish', [ApprovalActionController::class, 'publish']);
Route::post('/submissions/{submission}/reject', [ApprovalActionController::class, 'reject']);
